# GreenAdmin - Free Bootstrap 5 Admin Dashboard Template

A modern, clean, and responsive admin dashboard template built with **Bootstrap 5.3** and custom CSS. Inspired by TailAdmin's UI/UX design patterns. **36+ pages included.**

## Features

- **Pure Bootstrap 5.3** - No extra CSS frameworks needed
- **3 Theme Modes** - Full Light, Full Dark, Mix (dark sidebar + light content)
- **10 Color Palettes** - Green, Blue, Purple, Red, Orange, Teal, Indigo, Rose, Amber, Cyan (Tailwind-inspired)
- **Theme Customizer Panel** - Floating settings button opens a beautiful drawer panel to switch modes & colors
- **Theme Persistence** - Saved to localStorage, applies across all pages instantly
- **3-Level Sidebar Navigation** - Supports nested submenus up to 3 levels deep
- **Desktop Sidebar Collapse** - Click hamburger to collapse sidebar to icon-only mode
- **Active Parent Highlighting** - Parent menu auto-expands and highlights when child is active
- **Responsive Design** - Mobile slide-over sidebar with overlay
- **DataTables** - Custom JS DataTable engine with search, sort, and pagination
- **Chart.js Integration** - 6 chart types (Line, Bar, Doughnut, Polar, Radar, Area)
- **21 UI Element Pages** - Alerts, Badges, Breadcrumb, Buttons, Buttons Group, Cards, Carousel, Dropdowns, Images, Links, List, Modals, Notifications, Pagination, Popovers, Progress Bars, Ribbons, Spinners, Tabs, Tooltips, Videos
- **Custom Components** - Ribbons, Toast notifications, Custom tabs, Custom alerts
- **Custom Form Elements** - Toggle switches, range sliders, file uploads
- **Calendar Page** - Monthly calendar grid with events
- **Messages / Inbox** - Email-style message list
- **Pricing Page** - 3-tier pricing cards with featured badge
- **FAQ Accordion** - Collapsible FAQ section
- **Profile Page** - Cover photo, stats, activity feed
- **Settings Page** - Personal info, password, notifications
- **Authentication Pages** - Sign In, Sign Up, Reset Password
- **404 Error Page** - Clean error page
- **No Build Tools Required** - Just open `index.html` in your browser

## Pages Included (36+)

### Dashboard
| Page | Description |
|------|-------------|
| `index.html` | Dashboard with stats, charts, tables, activity feed |

### Menu Pages
| Page | Description |
|------|-------------|
| `pages/calendar.html` | Monthly calendar with events |
| `pages/profile.html` | User profile with cover, stats, activity |
| `pages/messages.html` | Inbox / message list |

### Forms & Tables
| Page | Description |
|------|-------------|
| `pages/forms.html` | Form elements: inputs, selects, toggles, checkboxes, radios |
| `pages/form-layout.html` | Contact form, horizontal form, inline form |
| `pages/tables.html` | Basic data tables with avatars and badges |
| `pages/datatables.html` | DataTables with search, sort, pagination |
| `pages/charts.html` | 6 chart types using Chart.js |

### UI Elements (21 pages)
| Page | Description |
|------|-------------|
| `pages/alerts.html` | Custom alerts and Bootstrap alerts |
| `pages/badges.html` | Custom and Bootstrap badges |
| `pages/breadcrumb.html` | Default, custom dividers, with icons |
| `pages/buttons.html` | Custom and Bootstrap button styles |
| `pages/buttons-group.html` | Button groups, toolbar, checkbox/radio groups |
| `pages/cards.html` | Basic cards, stat cards, accent cards |
| `pages/carousel.html` | Slides with captions, indicators, crossfade |
| `pages/dropdowns.html` | Basic, split, directions, dark, with icons |
| `pages/images.html` | Responsive, shapes, overlays, figures |
| `pages/links.html` | Colors, utilities, stretched, with icons |
| `pages/list.html` | List groups: basic, badges, colored, custom |
| `pages/modals.html` | Sizes, centered, scrollable, static backdrop |
| `pages/notifications.html` | Toast notifications, Bootstrap toasts, alerts |
| `pages/pagination.html` | Sizes, icons, centered, rounded |
| `pages/popovers.html` | Directions, dismissible, HTML content |
| `pages/progress-bar.html` | Striped, animated, stacked, custom heights |
| `pages/ribbons.html` | Left, right, corner, colored ribbons |
| `pages/spinners.html` | Border, grow, sizes, button spinners |
| `pages/tabs.html` | Nav tabs, pills, vertical, custom tabs |
| `pages/tooltips.html` | Directions, on elements, on icons |
| `pages/videos.html` | YouTube, Vimeo, HTML5, aspect ratios |

### Other Pages
| Page | Description |
|------|-------------|
| `pages/pricing.html` | 3-tier pricing cards |
| `pages/faq.html` | FAQ accordion |
| `pages/settings.html` | Account settings, notifications, password |
| `pages/login.html` | Sign in with social login |
| `pages/signup.html` | Sign up with social login |
| `pages/reset-password.html` | Password reset |
| `pages/404.html` | Error page |

## Folder Structure

```
greenAdmin/
├── index.html              # Dashboard
├── README.md               # This file
├── css/
│   ├── admin.css           # Core styles & layout
│   └── theme.css           # Theme system: 3 modes + 10 color palettes
├── js/
│   └── admin.js            # Sidebar, theme, DataTable, tabs, toasts
└── pages/
    ├── calendar.html       # Calendar
    ├── profile.html        # User profile
    ├── messages.html       # Inbox
    ├── forms.html          # Form elements
    ├── form-layout.html    # Form layouts
    ├── tables.html         # Basic tables
    ├── datatables.html     # DataTables
    ├── charts.html         # Charts (Chart.js)
    ├── alerts.html         # Alerts
    ├── badges.html         # Badges
    ├── breadcrumb.html     # Breadcrumb
    ├── buttons.html        # Buttons
    ├── buttons-group.html  # Button groups
    ├── cards.html          # Cards
    ├── carousel.html       # Carousel
    ├── dropdowns.html      # Dropdowns
    ├── images.html         # Images
    ├── links.html          # Links
    ├── list.html           # List groups
    ├── modals.html         # Modals
    ├── notifications.html  # Notifications
    ├── pagination.html     # Pagination
    ├── popovers.html       # Popovers
    ├── progress-bar.html   # Progress bars
    ├── ribbons.html        # Ribbons
    ├── spinners.html       # Spinners
    ├── tabs.html           # Tabs
    ├── tooltips.html       # Tooltips
    ├── videos.html         # Videos
    ├── pricing.html        # Pricing plans
    ├── faq.html            # FAQ
    ├── settings.html       # Settings
    ├── login.html          # Sign in
    ├── signup.html         # Sign up
    ├── reset-password.html # Reset password
    └── 404.html            # Error page
```

## CDN Dependencies

- [Bootstrap 5.3.3](https://getbootstrap.com/)
- [Bootstrap Icons 1.11.3](https://icons.getbootstrap.com/)
- [Chart.js 4.4.7](https://www.chartjs.org/)
- [Google Fonts - Inter](https://fonts.google.com/specimen/Inter)

## Quick Start

1. Download the ZIP from [GreenGetWare](https://greengetware.com/greensoft/)
2. Extract and open `index.html` in your browser
3. Click the ⚙️ floating button (bottom-right) to open the Theme Customizer
4. Choose your mode (Light / Dark / Mix) and color palette
5. Or customize via CSS variables in `css/theme.css`

## Theme System

### Appearance Modes
| Mode | Sidebar | Content Area |
|------|---------|-------------|
| **Light** | White/light sidebar | Light background |
| **Dark** | Dark sidebar | Dark background |
| **Mix** | Dark sidebar | Light background (classic admin look) |

### Color Palettes (10)
Green, Blue, Purple, Red, Orange, Teal, Indigo, Rose, Amber, Cyan

All colors are Tailwind CSS-inspired and defined as CSS custom properties in `css/theme.css`. To add a custom palette, add a new `[data-color="mycolor"]` block and register it in the `ThemeManager.colors` array in `js/admin.js`.

## License

Free to use for personal and commercial projects. No attribution required.

Made with care by [GreenGetWare](https://greengetware.com)
