const dropZone=document.getElementById("dropZone"),fileInput=document.getElementById("fileInput"),browseBtn=document.getElementById("browseBtn"),uploadProgress=document.getElementById("uploadProgress"),progressFill=document.getElementById("progressFill"),progressText=document.getElementById("progressText"),filesList=document.getElementById("filesList"),refreshBtn=document.getElementById("refreshBtn"),toast=document.getElementById("toast"),massDeleteBtn=document.getElementById("massDeleteBtn"),confirmModal=document.getElementById("confirmModal"),modalOverlay=document.getElementById("modalOverlay"),cancelBtn=document.getElementById("cancelBtn"),confirmDeleteBtn=document.getElementById("confirmDeleteBtn"),folderList=document.getElementById("folderList"),createFolderBtn=document.getElementById("createFolderBtn"),createFolderModal=document.getElementById("createFolderModal"),createFolderOverlay=document.getElementById("createFolderOverlay"),cancelCreateBtn=document.getElementById("cancelCreateBtn"),confirmCreateBtn=document.getElementById("confirmCreateBtn"),folderNameInput=document.getElementById("folderNameInput"),folderSelect=document.getElementById("folderSelect"),uploadHint=document.getElementById("uploadHint"),creditBtn=document.getElementById("creditBtn"),uploadQueue=document.getElementById("uploadQueue"),uploadQueueList=document.getElementById("uploadQueueList"),uploadQueueSubtitle=document.getElementById("uploadQueueSubtitle"),clearUploadQueueBtn=document.getElementById("clearUploadQueueBtn");let currentFolder="",maxUploadBytes=1048576e5,maxUploadFormatted="100000MB",uploadQueueItems=[],uploadQueueActive=!1;function formatDurationSeconds(e){if(!isFinite(e)||e<0)return"";const t=Math.floor(e),n=Math.floor(t/3600),o=Math.floor(t%3600/60),r=t%60,i=e=>String(e).padStart(2,"0");return n>0?`${n}:${i(o)}:${i(r)}`:`${o}:${i(r)}`}function formatBytesPerSecond(e){return!isFinite(e)||e<=0?"":`${formatFileSize(e)}/s`}async function confirmWithSwal({title:e,text:t,icon:n="warning",confirmButtonText:o="Yes",cancelButtonText:r="Cancel"}){try{if("undefined"!=typeof Swal&&Swal&&"function"==typeof Swal.fire){return!!(await Swal.fire({title:e,text:t,icon:n,showCancelButton:!0,confirmButtonText:o,cancelButtonText:r,reverseButtons:!0,focusCancel:!0})).isConfirmed}}catch(e){}return window.confirm(`${e}\n\n${t}`)}async function loadUploadLimits(){try{const e=await fetch("api?action=upload_limits");if(!e.ok)return;const t=await e.json();t&&t.effective&&"number"==typeof t.effective.bytes&&(-1===t.effective.bytes||t.effective.bytes>0)&&(maxUploadBytes=t.effective.bytes,maxUploadFormatted=t.effective.formatted||maxUploadFormatted,uploadHint&&(uploadHint.textContent=`Select a folder, then drag & drop or click browse (Max ${maxUploadFormatted} per file)`))}catch(e){}}function setupEventListeners(){browseBtn.addEventListener("click",(e=>{e.stopPropagation(),fileInput.click()})),fileInput.addEventListener("change",handleFileSelect),dropZone.addEventListener("dragover",handleDragOver),dropZone.addEventListener("dragleave",handleDragLeave),dropZone.addEventListener("drop",handleDrop),refreshBtn.addEventListener("click",(()=>{const e=refreshBtn.querySelector("svg");e&&(e.classList.add("spinner"),setTimeout((()=>e.classList.remove("spinner")),1e3)),loadFiles(!0),loadStorageInfo(),loadFolders()})),massDeleteBtn.addEventListener("click",showDeleteConfirmation),cancelBtn.addEventListener("click",hideDeleteConfirmation),modalOverlay.addEventListener("click",hideDeleteConfirmation),confirmDeleteBtn.addEventListener("click",(()=>massDeleteFiles())),createFolderBtn.addEventListener("click",showCreateFolderModal),cancelCreateBtn.addEventListener("click",hideCreateFolderModal),createFolderOverlay.addEventListener("click",hideCreateFolderModal),confirmCreateBtn.addEventListener("click",createFolder),folderNameInput.addEventListener("keypress",(e=>{"Enter"===e.key&&createFolder()})),document.addEventListener("dragover",(e=>e.preventDefault())),document.addEventListener("drop",(e=>e.preventDefault())),creditBtn&&creditBtn.addEventListener("click",showCredits),clearUploadQueueBtn&&clearUploadQueueBtn.addEventListener("click",clearUploadQueue)}function clearUploadQueue(){uploadQueueItems=[],uploadQueueActive=!1,uploadQueueList&&(uploadQueueList.innerHTML=""),uploadQueueSubtitle&&(uploadQueueSubtitle.textContent="0 files"),uploadQueue&&(uploadQueue.style.display="none")}function _queueStatusLabel(e){return"queued"===e?"Queued":"uploading"===e?"Uploading":"success"===e?"Completed":"error"===e?"Failed":e||""}function renderUploadQueue(){uploadQueue&&uploadQueueList&&(uploadQueueItems.length?(uploadQueue.style.display="block",uploadQueueSubtitle&&(uploadQueueSubtitle.textContent=`${uploadQueueItems.length} file(s)`),uploadQueueList.innerHTML=uploadQueueItems.map((e=>{const t=Math.max(0,Math.min(100,Math.round(e.progress||0))),n="uploading"===e.status?"uploading":"success"===e.status?"success":"error"===e.status?"error":"",o="success"===e.status?"success":"error"===e.status?"error":"",r=[formatFileSize(e.size)];return e.error&&r.push(e.error),`\n            <div class="upload-queue-item ${o}" data-queue-id="${e.id}">\n                <div class="upload-queue-row">\n                    <div class="upload-queue-file">\n                        <div class="upload-queue-name" title="${escapeHtml(e.name)}">${escapeHtml(e.name)}</div>\n                        <div class="upload-queue-meta">${escapeHtml(r.join(" • "))}</div>\n                    </div>\n                    <div class="upload-queue-status ${n}">${_queueStatusLabel(e.status)}</div>\n                </div>\n                <div class="upload-queue-progress">\n                    <div class="upload-queue-progress-fill" style="width:${t}%"></div>\n                </div>\n            </div>\n        `})).join("")):uploadQueue.style.display="none")}function updateQueueItem(e,t){const n=uploadQueueItems.findIndex((t=>t.id===e));-1!==n&&(uploadQueueItems[n]={...uploadQueueItems[n],...t},renderUploadQueue())}function uploadSingleFileXHR(e,t,n){return new Promise((o=>{const r=new FormData;r.append("files[]",e),t&&r.append("folder",t);const i=new XMLHttpRequest;i.open("POST","api",!0),i.upload.addEventListener("progress",(e=>{e.lengthComputable&&"function"==typeof n&&n(e.loaded,e.total)})),i.addEventListener("load",(()=>{if(200===i.status)try{const e=JSON.parse(i.responseText);if(Array.isArray(e.success)?e.success.length>0:!!e.success)return void o({ok:!0,json:e});const t=Array.isArray(e.errors)&&e.errors.length?e.errors[0]:e.error||"Upload failed";o({ok:!1,error:String(t)})}catch(e){o({ok:!1,error:"Invalid server response"})}else o({ok:!1,error:`HTTP ${i.status}`})})),i.addEventListener("error",(()=>{o({ok:!1,error:"Network error"})})),i.send(r)}))}function showCredits(){try{if("undefined"!=typeof Swal&&Swal&&"function"==typeof Swal.fire)return void Swal.fire({title:"Credits",html:'<div style="text-align:left; line-height:1.6"><div style="font-weight:700; font-size:16px; color:#0f172a">Marli Rukmana</div><div style="margin-top:6px; color:#475569">UI/UX & Development</div><div style="margin-top:10px; font-size:13px; color:#64748b">Thank you for using FolderShare.</div></div>',icon:"info",confirmButtonText:"OK"})}catch(e){}window.alert("Credits\n\nMarli Rukmana\nUI/UX & Development")}function handleDragOver(e){e.preventDefault(),e.stopPropagation(),dropZone.classList.add("drag-over")}function handleDragLeave(e){e.preventDefault(),e.stopPropagation(),dropZone.classList.remove("drag-over")}function handleDrop(e){e.preventDefault(),e.stopPropagation(),dropZone.classList.remove("drag-over");const t=e.dataTransfer.files;t.length>0&&uploadFiles(t)}function handleFileSelect(e){const t=e.target.files;t.length>0&&uploadFiles(t)}async function uploadFiles(e){const t=folderSelect&&folderSelect.value?folderSelect.value:"",n=maxUploadBytes;if(uploadQueueActive)return void showToast("Upload is in progress. Please wait.","warning");try{const e=await fetch("api?action=storage");if((await e.json()).percentage>=95)return void showToast("Storage is almost full. Please delete some files first.","error")}catch(e){}const o=Array.from(e||[]);if(!o.length)return;for(const e of o)if(-1!==n&&e.size>n)return void showToast(`File ${e.name} is too large (max ${maxUploadFormatted})`,"error");const r=Date.now();uploadQueueItems=o.map(((e,t)=>({id:`${r}_${t}_${Math.random().toString(16).slice(2)}`,name:e.name,size:e.size,status:"queued",progress:0,error:""}))),renderUploadQueue(),uploadQueueActive=!0,uploadProgress.style.display="block",progressFill.style.width="0%",progressText.textContent=`Uploading ${o.length} file(s)...`;const i=o.reduce(((e,t)=>e+(t.size||0)),0)||1;let a=0,l=0,d=0;for(let e=0;e<o.length;e++){const n=o[e],r=uploadQueueItems[e];if(!r)continue;updateQueueItem(r.id,{status:"uploading",progress:0,error:""});const s=Date.now();let c=0;const u=await uploadSingleFileXHR(n,t,((t,n)=>{c=t;const l=n>0?t/n*100:0;updateQueueItem(r.id,{progress:l});const d=(a+t)/i*100;progressFill.style.width=`${Math.min(100,Math.max(0,d))}%`;const u=(Date.now()-s)/1e3,p=u>0?t/u:0,f=p>0?(n-t)/p:NaN,m=formatBytesPerSecond(p),v=isFinite(f)?formatDurationSeconds(f):"",w=[`Uploading ${e+1}/${o.length}`];w.push(`${Math.round(d)}%`),m&&w.push(m),v&&w.push(`ETA ${v}`),progressText.textContent=w.join(" | ")}));a+=n.size||c||0,u.ok?(l+=1,updateQueueItem(r.id,{status:"success",progress:100})):(d+=1,updateQueueItem(r.id,{status:"error",progress:100,error:u.error||"Upload failed"}))}uploadQueueActive=!1,progressFill.style.width="100%",0===d?showToast(`Uploaded ${l} file(s) successfully`,"success"):0===l?showToast("Upload failed. Please try again.","error"):showToast(`Uploaded ${l} file(s), ${d} failed`,"warning"),loadFiles(!0),loadStorageInfo(),loadFolders(),fileInput.value="",setTimeout((()=>{uploadProgress.style.display="none"}),1200)}async function loadStorageInfo(){try{const e=await fetch("api?action=storage"),t=await e.json(),n=document.getElementById("storageUsed"),o=document.getElementById("storageTotal"),r=document.getElementById("spaceAvailable"),i=document.getElementById("usagePercentage"),a=document.getElementById("capacityFill"),l=formatFileSize(t.used),d=formatFileSize(t.total),s=formatFileSize(t.available),c=Math.round(t.percentage);n.textContent=l,o&&(o.textContent=d),r.textContent=s,i.textContent=c+"%",a.style.width=c+"%",a.setAttribute("data-percentage",c);const u=document.querySelector(".storage-card");u.style.borderColor=c>=90?"var(--danger)":c>=70?"var(--warning)":"var(--border)"}catch(e){}}document.addEventListener("DOMContentLoaded",(()=>{loadFolders(),loadFiles(),loadStorageInfo(),loadUploadLimits(),setupEventListeners()}));let currentFilesCache=[];async function loadFiles(e=!1){const t=filesList.scrollTop,n=document.querySelector(".content-area")?.scrollTop||0;e||(filesList.innerHTML='<div class="loading">Loading files...</div>');try{let o="api?action=list";currentFolder&&(o+=`&folder=${encodeURIComponent(currentFolder)}`);const r=await fetch(o),i=await r.json();if(0===i.length){filesList.innerHTML='\n                <div class="empty-state">\n                    <svg width="64" height="64" viewBox="0 0 64 64" fill="none">\n                        <path d="M8 16C8 13.7909 9.79086 12 12 12H24L28 16H52C54.2091 16 56 17.7909 56 20V48C56 50.2091 54.2091 52 52 52H12C9.79086 52 8 50.2091 8 48V16Z" stroke="#cbd5e1" stroke-width="3"/>\n                    </svg>\n                    <h3>No files yet</h3>\n                    <p>Upload files to start sharing</p>\n                </div>\n            ',massDeleteBtn.style.display="none";const e=document.getElementById("totalFiles");return e&&(e.textContent="0"),void(currentFilesCache=[])}const a=!e||JSON.stringify(i.map((e=>e.name)))!==JSON.stringify(currentFilesCache.map((e=>e.name)));if((a||!e)&&(filesList.innerHTML=i.map((e=>createFileItem(e))).join(""),e&&a&&i.length!==currentFilesCache.length)){filesList.querySelectorAll(".file-item").forEach((e=>{e.style.animation="none",e.offsetHeight,e.style.animation="fadeInSmooth 0.3s ease forwards"}))}currentFilesCache=i;const l=document.getElementById("totalFiles");if(l&&(l.textContent=i.length),massDeleteBtn.style.display="inline-flex",document.querySelectorAll(".btn-danger").forEach((e=>{e.addEventListener("click",(()=>deleteFile(e.dataset.filename)))})),e){filesList.scrollTop=t;const e=document.querySelector(".content-area");e&&(e.scrollTop=n)}}catch(t){e||(filesList.innerHTML='\n                <div class="empty-state">\n                    <h3>Failed to load files</h3>\n                    <p>Please refresh the page</p>\n                </div>\n            ')}}function createFileItem(e){const t=getFileExtension(e.original_name),n=getFileIcon(t),o=formatFileSize(e.size),r=getTimeAgo(e.date),i=isPreviewable(t);return`\n        <div class="file-item" data-file='${JSON.stringify(e).replace(/'/g,"&#39;")}'>\n            <div class="file-icon">\n                ${n}\n            </div>\n            <div class="file-info">\n                <div class="file-name" title="${e.original_name}">${e.original_name}</div>\n                <div class="file-meta">\n                    <span>${o}</span>\n                    <span>${r}</span>\n                    <span>${e.date_formatted}</span>\n                </div>\n            </div>\n            <div class="file-actions">\n                ${i?`\n                <button class="btn-preview" data-filename="${e.name}" title="Preview">\n                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none">\n                        <path d="M1 8C1 8 3.5 3 8 3C12.5 3 15 8 15 8C15 8 12.5 13 8 13C3.5 13 1 8 1 8Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>\n                        <circle cx="8" cy="8" r="2.5" stroke="currentColor" stroke-width="2"/>\n                    </svg>\n                    Preview\n                </button>\n                `:""}\n                <a href="api?download=${encodeURIComponent(e.name)}${e.folder?"&folder="+encodeURIComponent(e.folder):""}" class="btn-success" download>\n                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none">\n                        <path d="M8 2V12M8 12L4 8M8 12L12 8" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>\n                        <path d="M2 14H14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>\n                    </svg>\n                    Download\n                </a>\n                <button class="btn-danger" data-filename="${e.name}">\n                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none">\n                        <path d="M2 4H14M6 2H10M6 7V12M10 7V12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>\n                    </svg>\n                    Delete\n                </button>\n            </div>\n        </div>\n    `}function isPreviewable(e){return["jpg","jpeg","png","gif","webp","svg","bmp","ico","mp4","webm","ogg","mov","mp3","wav","ogg","flac","m4a","pdf","txt","json","xml","html","css","js","php","py","java","c","cpp","h","md","sql","sh","bat","yml","yaml","ini","log","csv"].includes(e.toLowerCase())}async function deleteFile(e){if(await confirmWithSwal({title:"Delete file?",text:"The file will be deleted and cannot be restored.",icon:"warning",confirmButtonText:"Yes, delete",cancelButtonText:"Cancel"}))try{const t=new FormData;t.append("action","delete"),t.append("filename",e),currentFolder&&t.append("folder",currentFolder);const n=await fetch("api",{method:"POST",body:t});(await n.json()).success?(showToast("File deleted successfully","success"),loadFiles(!0),loadStorageInfo(),loadFolders()):showToast("Failed to delete file","error")}catch(e){showToast("An error occurred while deleting the file","error")}}function getFileExtension(e){return e.split(".").pop().toLowerCase()}function getFileIcon(e){return`<svg width="24" height="24" viewBox="0 0 20 20" fill="none">\n        ${{pdf:'<path d="M4 2H12L16 6V18C16 19.1046 15.1046 20 14 20H4C2.89543 20 2 19.1046 2 18V4C2 2.89543 2.89543 2 4 2Z" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>',doc:'<path d="M4 2H12L16 6V18C16 19.1046 15.1046 20 14 20H4C2.89543 20 2 19.1046 2 18V4C2 2.89543 2.89543 2 4 2Z" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>',docx:'<path d="M4 2H12L16 6V18C16 19.1046 15.1046 20 14 20H4C2.89543 20 2 19.1046 2 18V4C2 2.89543 2.89543 2 4 2Z" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>',xls:'<path d="M4 2H12L16 6V18C16 19.1046 15.1046 20 14 20H4C2.89543 20 2 19.1046 2 18V4C2 2.89543 2.89543 2 4 2Z" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>',xlsx:'<path d="M4 2H12L16 6V18C16 19.1046 15.1046 20 14 20H4C2.89543 20 2 19.1046 2 18V4C2 2.89543 2.89543 2 4 2Z" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>',jpg:'<path d="M3 3H15C16.1046 3 17 3.89543 17 5V15C17 16.1046 16.1046 17 15 17H3C1.89543 17 1 16.1046 1 15V5C1 3.89543 1.89543 3 3 3Z" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><circle cx="6.5" cy="7.5" r="1.5" fill="white"/>',jpeg:'<path d="M3 3H15C16.1046 3 17 3.89543 17 5V15C17 16.1046 16.1046 17 15 17H3C1.89543 17 1 16.1046 1 15V5C1 3.89543 1.89543 3 3 3Z" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><circle cx="6.5" cy="7.5" r="1.5" fill="white"/>',png:'<path d="M3 3H15C16.1046 3 17 3.89543 17 5V15C17 16.1046 16.1046 17 15 17H3C1.89543 17 1 16.1046 1 15V5C1 3.89543 1.89543 3 3 3Z" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><circle cx="6.5" cy="7.5" r="1.5" fill="white"/>',zip:'<path d="M8 2V10M4 6H12V14C12 15.1046 11.1046 16 10 16H6C4.89543 16 4 15.1046 4 14V6Z" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>',rar:'<path d="M8 2V10M4 6H12V14C12 15.1046 11.1046 16 10 16H6C4.89543 16 4 15.1046 4 14V6Z" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>'}[e]||'<path d="M4 2H12L16 6V18C16 19.1046 15.1046 20 14 20H4C2.89543 20 2 19.1046 2 18V4C2 2.89543 2.89543 2 4 2Z" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>'}\n    </svg>`}function formatFileSize(e){if(0===e)return"0 Bytes";const t=Math.floor(Math.log(e)/Math.log(1024));return Math.round(e/Math.pow(1024,t)*100)/100+" "+["Bytes","KB","MB","GB"][t]}function getTimeAgo(e){const t=Math.floor(Date.now()/1e3)-e;return t<60?"Just now":t<3600?Math.floor(t/60)+" minutes ago":t<86400?Math.floor(t/3600)+" hours ago":Math.floor(t/86400)+" days ago"}function showToast(e,t="info"){toast.textContent=e,toast.className="toast show "+t,setTimeout((()=>{toast.classList.remove("show")}),3e3)}async function showDeleteConfirmation(){const e=document.getElementById("totalFiles"),t=e?e.textContent:"0";if("0"===t)return void showToast("No files to delete","warning");const n=currentFolder?`in folder "${currentFolder}"`:"in all folders";await confirmWithSwal({title:"Delete all files?",text:`You will delete ${t} file(s) ${n}. This action cannot be undone.`,icon:"warning",confirmButtonText:"Yes, delete all",cancelButtonText:"Cancel"})&&await massDeleteFiles(!0)}function hideDeleteConfirmation(){confirmModal.classList.remove("show"),document.body.style.overflow=""}async function massDeleteFiles(e=!1){!e&&confirmDeleteBtn&&(confirmDeleteBtn.disabled=!0,confirmDeleteBtn.innerHTML='\n            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" class="spinner">\n                <circle cx="8" cy="8" r="6" stroke="currentColor" stroke-width="2" stroke-dasharray="10 5" />\n            </svg>\n            Deleting...\n        ');try{let t=!1;e&&"undefined"!=typeof Swal&&Swal&&"function"==typeof Swal.fire&&(Swal.fire({title:"Deleting...",text:"Please wait",allowOutsideClick:!1,allowEscapeKey:!1,didOpen:()=>{Swal.showLoading()}}),t=!0);const n=new FormData;n.append("action","delete_all"),currentFolder&&n.append("folder",currentFolder),currentFolder&&n.append("folder",currentFolder);const o=await fetch("api",{method:"POST",body:n}),r=await o.json();r.success?(e&&"undefined"!=typeof Swal&&Swal&&"function"==typeof Swal.fire?(t&&"function"==typeof Swal.close&&Swal.close(),await Swal.fire({title:"Success",text:`Deleted ${r.deleted} file(s)`,icon:"success",timer:1500,showConfirmButton:!1})):showToast(`Deleted ${r.deleted} file(s)`,"success"),loadFiles(!0),loadStorageInfo(),loadFolders()):e&&"undefined"!=typeof Swal&&Swal&&"function"==typeof Swal.fire?(t&&"function"==typeof Swal.close&&Swal.close(),await Swal.fire({title:"Failed",text:"Failed to delete files",icon:"error"})):showToast("Failed to delete files","error")}catch(t){e&&"undefined"!=typeof Swal&&Swal&&"function"==typeof Swal.fire?(swalLoadingShown&&"function"==typeof Swal.close&&Swal.close(),await Swal.fire({title:"Error",text:"An error occurred while deleting files",icon:"error"})):showToast("An error occurred while deleting files","error")}finally{!e&&confirmDeleteBtn&&(confirmDeleteBtn.disabled=!1,confirmDeleteBtn.innerHTML='\n                <svg width="16" height="16" viewBox="0 0 16 16" fill="none">\n                    <path d="M2 4H14M6 2H10M6 7V12M10 7V12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>\n                </svg>\n                Yes, Delete All\n            ')}}async function loadFolders(){try{const e=await fetch("api?action=folders"),t=await e.json(),n=folderList.querySelector('[data-folder=""]');folderList.innerHTML="",folderList.appendChild(n);const o=await fetch("api?action=list"),r=await o.json();n.querySelector(".folder-count").textContent=r.length,t.forEach((e=>{const t=createFolderItem(e);folderList.appendChild(t)})),updateFolderSelect(t),document.querySelectorAll(".folder-item").forEach((e=>{e.addEventListener("click",(t=>{t.target.classList.contains("folder-delete")||switchFolder(e.dataset.folder)}))})),document.querySelectorAll(".folder-delete").forEach((e=>{e.addEventListener("click",(t=>{t.stopPropagation(),deleteFolder(e.dataset.folder)}))}))}catch(e){}}function createFolderItem(e){const t=document.createElement("div");return t.className="folder-item",t.dataset.folder=e.name,t.innerHTML=`\n        <svg width="18" height="18" viewBox="0 0 18 18" fill="none">\n            <path d="M2 4C2 3.44772 3.44772 2 4 2H7L9 4H14C14.5523 4 16 3.44772 16 4V14C16 14.5523 14.5523 16 14 16H4C3.44772 16 2 14.5523 2 14V4Z" stroke="currentColor" stroke-width="2"/>\n        </svg>\n        <span>${e.name}</span>\n        <span class="folder-count">${e.file_count}</span>\n        <button class="folder-delete" data-folder="${e.name}" title="Delete folder">\n            <svg width="12" height="12" viewBox="0 0 12 12" fill="none">\n                <path d="M2 2L10 10M10 2L2 10" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>\n            </svg>\n        </button>\n    `,t}function updateFolderSelect(e){folderSelect.innerHTML='<option value="">📁 Root Folder</option>',e.forEach((e=>{const t=document.createElement("option");t.value=e.name,t.textContent=`📁 ${e.name}`,folderSelect.appendChild(t)}))}function switchFolder(e){currentFolder=e,document.querySelectorAll(".folder-item").forEach((t=>{t.classList.remove("active"),t.dataset.folder===e&&t.classList.add("active")})),folderSelect.value=e,loadFiles(!0)}function showCreateFolderModal(){folderNameInput.value="",createFolderModal.classList.add("show"),document.body.style.overflow="hidden",setTimeout((()=>folderNameInput.focus()),100)}function hideCreateFolderModal(){createFolderModal.classList.remove("show"),document.body.style.overflow=""}async function createFolder(){const e=folderNameInput.value.trim();if(e){confirmCreateBtn.disabled=!0,confirmCreateBtn.innerHTML='\n        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" class="spinner">\n            <circle cx="8" cy="8" r="6" stroke="currentColor" stroke-width="2" stroke-dasharray="10 5" />\n        </svg>\n        Creating...\n    ';try{const t=new FormData;t.append("action","create_folder"),t.append("folder_name",e);const n=await fetch("api",{method:"POST",body:t}),o=await n.json();o.success?(hideCreateFolderModal(),showToast(`Folder "${o.folder_name}" created successfully`,"success"),loadFolders()):showToast(o.error||"Failed to create folder","error")}catch(e){showToast("An error occurred while creating the folder","error")}finally{confirmCreateBtn.disabled=!1,confirmCreateBtn.innerHTML='\n            <svg width="16" height="16" viewBox="0 0 16 16" fill="none">\n                <path d="M3 4H13M6 2H10M6 8V13" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>\n                <path d="M8 4V14H13" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>\n            </svg>\n            Create Folder\n        '}}else showToast("Folder name cannot be empty","error")}async function deleteFolder(e){if(await confirmWithSwal({title:"Delete folder?",text:`Folder "${e}" and all its contents will be deleted.`,icon:"warning",confirmButtonText:"Yes, delete folder",cancelButtonText:"Cancel"}))try{const t=new FormData;t.append("action","delete_folder"),t.append("folder_name",e);const n=await fetch("api",{method:"POST",body:t}),o=await n.json();o.success?(showToast(`Folder "${e}" deleted successfully`,"success"),currentFolder===e&&switchFolder(""),loadFolders(),loadStorageInfo()):showToast(o.error||"Failed to delete folder","error")}catch(e){showToast("An error occurred while deleting the folder","error")}}setInterval((()=>{loadFiles(!0),loadStorageInfo(),loadFolders()}),3e4);let previewFiles=[],currentPreviewIndex=0;const previewModal=document.getElementById("previewModal"),previewOverlay=document.getElementById("previewOverlay"),previewCloseBtn=document.getElementById("previewCloseBtn"),previewContent=document.getElementById("previewContent"),previewFileName=document.getElementById("previewFileName"),previewFileSize=document.getElementById("previewFileSize"),previewFileType=document.getElementById("previewFileType"),previewFileDate=document.getElementById("previewFileDate"),previewIcon=document.getElementById("previewIcon"),previewDownloadBtn=document.getElementById("previewDownloadBtn"),previewPrevBtn=document.getElementById("previewPrevBtn"),previewNextBtn=document.getElementById("previewNextBtn"),previewCurrentIndex=document.getElementById("previewCurrentIndex"),previewTotalCount=document.getElementById("previewTotalCount");function initPreviewListeners(){previewCloseBtn.addEventListener("click",closePreview),previewOverlay.addEventListener("click",closePreview),previewPrevBtn.addEventListener("click",(()=>navigatePreview(-1))),previewNextBtn.addEventListener("click",(()=>navigatePreview(1))),document.addEventListener("keydown",handlePreviewKeyboard)}function handlePreviewKeyboard(e){if(previewModal.classList.contains("show"))switch(e.key){case"Escape":closePreview();break;case"ArrowLeft":navigatePreview(-1);break;case"ArrowRight":navigatePreview(1)}}function openPreview(e,t){previewFiles=Array.from(document.querySelectorAll(".file-item")).map((e=>{try{return JSON.parse(e.dataset.file.replace(/&#39;/g,"'"))}catch(e){return null}})).filter((e=>e&&isPreviewable(getFileExtension(e.original_name)))),currentPreviewIndex=previewFiles.findIndex((t=>t.name===e.name)),-1===currentPreviewIndex&&(currentPreviewIndex=0),showPreviewModal(previewFiles[currentPreviewIndex])}function showPreviewModal(e){const t=getFileExtension(e.original_name),n=getFileType(t),o=getFileUrl(e);previewFileName.textContent=e.original_name,previewFileSize.textContent=formatFileSize(e.size),previewFileType.textContent=n,previewFileDate.textContent=e.date_formatted,previewIcon.innerHTML=getPreviewHeaderIcon(t),previewDownloadBtn.href=`api?download=${encodeURIComponent(e.name)}${e.folder?"&folder="+encodeURIComponent(e.folder):""}`,previewCurrentIndex.textContent=currentPreviewIndex+1,previewTotalCount.textContent=previewFiles.length,previewPrevBtn.disabled=0===currentPreviewIndex,previewNextBtn.disabled=currentPreviewIndex===previewFiles.length-1,previewContent.innerHTML=generatePreviewContent(e,t,o),previewModal.classList.add("show"),document.body.style.overflow="hidden"}function closePreview(){previewModal.classList.remove("show"),document.body.style.overflow="";const e=previewContent.querySelector("video"),t=previewContent.querySelector("audio");e&&e.pause(),t&&t.pause()}function navigatePreview(e){const t=currentPreviewIndex+e;t>=0&&t<previewFiles.length&&(currentPreviewIndex=t,showPreviewModal(previewFiles[currentPreviewIndex]))}function getFileUrl(e){const t=e.folder?`&folder=${encodeURIComponent(e.folder)}`:"";return`api?preview=${encodeURIComponent(e.name)}${t}`}function getFileType(e){return{jpg:"JPEG Image",jpeg:"JPEG Image",png:"PNG Image",gif:"GIF Image",webp:"WebP Image",svg:"SVG Image",bmp:"Bitmap Image",ico:"Icon",mp4:"MP4 Video",webm:"WebM Video",ogg:"OGG Video",mov:"MOV Video",mp3:"MP3 Audio",wav:"WAV Audio",flac:"FLAC Audio",m4a:"M4A Audio",pdf:"PDF Document",txt:"Text File",json:"JSON File",xml:"XML File",html:"HTML File",css:"CSS File",js:"JavaScript",php:"PHP File",py:"Python File",java:"Java File",c:"C File",cpp:"C++ File",h:"Header File",md:"Markdown",sql:"SQL File",sh:"Shell Script",bat:"Batch File",yml:"YAML File",yaml:"YAML File",ini:"INI File",log:"Log File",csv:"CSV File"}[e.toLowerCase()]||"File"}function getPreviewHeaderIcon(e){const t=e.toLowerCase();return["jpg","jpeg","png","gif","webp","svg","bmp","ico"].includes(t)?'<svg width="24" height="24" viewBox="0 0 24 24" fill="none">\n            <rect x="3" y="3" width="18" height="18" rx="3" stroke="white" stroke-width="2"/>\n            <circle cx="8.5" cy="8.5" r="2" stroke="white" stroke-width="2"/>\n            <path d="M21 15L16 10L6 21" stroke="white" stroke-width="2" stroke-linecap="round"/>\n        </svg>':["mp4","webm","ogg","mov"].includes(t)?'<svg width="24" height="24" viewBox="0 0 24 24" fill="none">\n            <rect x="2" y="4" width="20" height="16" rx="3" stroke="white" stroke-width="2"/>\n            <path d="M10 9L15 12L10 15V9Z" fill="white"/>\n        </svg>':["mp3","wav","flac","m4a"].includes(t)?'<svg width="24" height="24" viewBox="0 0 24 24" fill="none">\n            <path d="M9 18V6L21 3V15" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>\n            <circle cx="6" cy="18" r="3" stroke="white" stroke-width="2"/>\n            <circle cx="18" cy="15" r="3" stroke="white" stroke-width="2"/>\n        </svg>':"pdf"===t?'<svg width="24" height="24" viewBox="0 0 24 24" fill="none">\n            <path d="M4 4C4 2.89543 4.89543 2 6 2H14L20 8V20C20 21.1046 19.1046 22 18 22H6C4.89543 22 4 21.1046 4 20V4Z" stroke="white" stroke-width="2"/>\n            <path d="M14 2V8H20" stroke="white" stroke-width="2" stroke-linecap="round"/>\n            <path d="M8 13H16M8 17H12" stroke="white" stroke-width="2" stroke-linecap="round"/>\n        </svg>':'<svg width="24" height="24" viewBox="0 0 24 24" fill="none">\n        <path d="M4 4C4 2.89543 4.89543 2 6 2H14L20 8V20C20 21.1046 19.1046 22 18 22H6C4.89543 22 4 21.1046 4 20V4Z" stroke="white" stroke-width="2"/>\n        <path d="M14 2V8H20" stroke="white" stroke-width="2" stroke-linecap="round"/>\n        <path d="M9 13L7 15L9 17M15 13L17 15L15 17M13 12L11 18" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>\n    </svg>'}function generatePreviewContent(e,t,n){const o=t.toLowerCase();return["jpg","jpeg","png","gif","webp","svg","bmp","ico"].includes(o)?`<img src="${n}" alt="${e.original_name}" loading="lazy">`:["mp4","webm","ogg","mov"].includes(o)?`<video controls autoplay>\n            <source src="${n}" type="video/${"mov"===o?"mp4":o}">\n            Your browser does not support video.\n        </video>`:["mp3","wav","flac","m4a"].includes(o)?`<div class="preview-audio-container">\n            <div class="preview-audio-icon">\n                <svg viewBox="0 0 24 24" fill="none">\n                    <path d="M9 18V6L21 3V15" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>\n                    <circle cx="6" cy="18" r="3" stroke="currentColor" stroke-width="2"/>\n                    <circle cx="18" cy="15" r="3" stroke="currentColor" stroke-width="2"/>\n                </svg>\n            </div>\n            <h4 style="color: white; margin: 0;">${e.original_name}</h4>\n            <audio controls autoplay>\n                <source src="${n}" type="audio/${"m4a"===o?"mp4":o}">\n                Your browser does not support audio.\n            </audio>\n        </div>`:"pdf"===o?(setTimeout((()=>loadPdfPreview(n)),100),'<div class="preview-pdf-wrapper">\n            <div class="pdf-toolbar">\n                <div class="pdf-nav-controls">\n                    <button class="pdf-btn" id="pdfPrevPage" title="Previous Page">\n                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">\n                            <path d="M10 12L6 8L10 4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>\n                        </svg>\n                    </button>\n                    <span class="pdf-page-info">\n                        <span id="pdfCurrentPage">1</span> / <span id="pdfTotalPages">1</span>\n                    </span>\n                    <button class="pdf-btn" id="pdfNextPage" title="Next Page">\n                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">\n                            <path d="M6 4L10 8L6 12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>\n                        </svg>\n                    </button>\n                </div>\n                <div class="pdf-zoom-controls">\n                    <button class="pdf-btn" id="pdfZoomOut" title="Zoom Out">\n                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">\n                            <circle cx="7" cy="7" r="5" stroke="currentColor" stroke-width="2"/>\n                            <path d="M11 11L14 14M5 7H9" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>\n                        </svg>\n                    </button>\n                    <span class="pdf-zoom-level" id="pdfZoomLevel">100%</span>\n                    <button class="pdf-btn" id="pdfZoomIn" title="Zoom In">\n                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">\n                            <circle cx="7" cy="7" r="5" stroke="currentColor" stroke-width="2"/>\n                            <path d="M11 11L14 14M5 7H9M7 5V9" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>\n                        </svg>\n                    </button>\n                    <button class="pdf-btn" id="pdfFitWidth" title="Fit Width">\n                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">\n                            <path d="M2 4H14M2 8H14M2 12H14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>\n                        </svg>\n                    </button>\n                </div>\n            </div>\n            <div class="pdf-canvas-container" id="pdfCanvasContainer">\n                <canvas id="pdfCanvas"></canvas>\n            </div>\n        </div>'):["txt","json","xml","html","css","js","php","py","java","c","cpp","h","md","sql","sh","bat","yml","yaml","ini","log","csv"].includes(o)?(loadTextPreview(n,o,e.original_name),'<div class="preview-loading">\n            <div class="preview-loading-spinner"></div>\n            <span>Loading content...</span>\n        </div>'):`<div class="preview-unsupported">\n        <div class="preview-unsupported-icon">\n            <svg viewBox="0 0 24 24" fill="none">\n                <path d="M4 4C4 2.89543 4.89543 2 6 2H14L20 8V20C20 21.1046 19.1046 22 18 22H6C4.89543 22 4 21.1046 4 20V4Z" stroke="currentColor" stroke-width="2"/>\n                <path d="M14 2V8H20" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>\n            </svg>\n        </div>\n        <h4>Preview not available</h4>\n        <p>This .${o} file cannot be displayed.<br>Please download to view.</p>\n    </div>`}async function loadTextPreview(e,t,n){try{const n=await fetch(e),o=await n.text(),r=getLanguageName(t),i=5e4,a=o.length>i?o.substring(0,i)+"\n\n... (File is too large, showing a partial preview)":o;previewContent.innerHTML=`\n            <div class="preview-code-container">\n                <div class="preview-code-header">\n                    <div class="preview-code-dots">\n                        <span class="preview-code-dot"></span>\n                        <span class="preview-code-dot"></span>\n                        <span class="preview-code-dot"></span>\n                    </div>\n                    <div class="preview-code-lang">\n                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none">\n                            <path d="M4 5L2 7L4 9M10 5L12 7L10 9M8 3L6 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>\n                        </svg>\n                        ${r}\n                    </div>\n                </div>\n                <pre class="preview-code-content">${escapeHtml(a)}</pre>\n            </div>\n        `}catch(e){previewContent.innerHTML='\n            <div class="preview-unsupported">\n                <div class="preview-unsupported-icon">\n                    <svg viewBox="0 0 24 24" fill="none">\n                        <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>\n                        <path d="M12 8V12M12 16V16.01" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>\n                    </svg>\n                </div>\n                <h4>Failed to load preview</h4>\n                <p>Unable to read file contents.</p>\n            </div>\n        '}}function getLanguageName(e){return{txt:"Plain Text",json:"JSON",xml:"XML",html:"HTML",css:"CSS",js:"JavaScript",php:"PHP",py:"Python",java:"Java",c:"C",cpp:"C++",h:"C Header",md:"Markdown",sql:"SQL",sh:"Shell",bat:"Batch",yml:"YAML",yaml:"YAML",ini:"INI",log:"Log",csv:"CSV"}[e.toLowerCase()]||"Text"}function escapeHtml(e){const t=document.createElement("div");return t.textContent=e,t.innerHTML}document.addEventListener("DOMContentLoaded",initPreviewListeners);const originalLoadFiles=loadFiles;loadFiles=async function(e=!1){await originalLoadFiles(e),document.querySelectorAll(".btn-preview").forEach((e=>{e.addEventListener("click",(t=>{t.stopPropagation();const n=e.closest(".file-item");openPreview(JSON.parse(n.dataset.file.replace(/&#39;/g,"'")))}))})),document.querySelectorAll(".file-item").forEach((e=>{e.addEventListener("dblclick",(()=>{const t=JSON.parse(e.dataset.file.replace(/&#39;/g,"'"));isPreviewable(getFileExtension(t.original_name))&&openPreview(t)}))}))};let pdfDoc=null,pdfPageNum=1,pdfPageRendering=!1,pdfPageNumPending=null,pdfScale=1.5,pdfCanvas=null,pdfCtx=null;async function loadPdfPreview(e){try{const t=document.getElementById("pdfCanvasContainer");if(!t)return;t.innerHTML='\n            <div class="preview-loading" style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);">\n                <div class="preview-loading-spinner"></div>\n                <span>Loading PDF...</span>\n            </div>\n            <canvas id="pdfCanvas" style="display: none;"></canvas>\n        ';const n=pdfjsLib.getDocument(e);pdfDoc=await n.promise,pdfCanvas=document.getElementById("pdfCanvas"),pdfCtx=pdfCanvas.getContext("2d"),document.getElementById("pdfTotalPages").textContent=pdfDoc.numPages,await calculateFitWidth(),pdfPageNum=1,await renderPdfPage(pdfPageNum),pdfCanvas.style.display="block",t.querySelector(".preview-loading")?.remove(),setupPdfControls()}catch(e){const t=document.getElementById("pdfCanvasContainer");t&&(t.innerHTML='\n                <div class="preview-unsupported">\n                    <div class="preview-unsupported-icon">\n                        <svg viewBox="0 0 24 24" fill="none">\n                            <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>\n                            <path d="M12 8V12M12 16V16.01" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>\n                        </svg>\n                    </div>\n                    <h4>Gagal memuat PDF</h4>\n                    <p>Silakan download file untuk melihat.</p>\n                </div>\n            ')}}async function calculateFitWidth(){if(!pdfDoc)return;const e=await pdfDoc.getPage(1),t=document.getElementById("pdfCanvasContainer").clientWidth-40,n=e.getViewport({scale:1});pdfScale=t/n.width,pdfScale>2&&(pdfScale=2),pdfScale<.5&&(pdfScale=.5),updateZoomLevel()}async function renderPdfPage(e){if(pdfDoc&&pdfCanvas&&pdfCtx){pdfPageRendering=!0;try{const t=await pdfDoc.getPage(e),n=t.getViewport({scale:pdfScale});pdfCanvas.height=n.height,pdfCanvas.width=n.width;const o={canvasContext:pdfCtx,viewport:n};await t.render(o).promise,pdfPageRendering=!1,document.getElementById("pdfCurrentPage").textContent=e,document.getElementById("pdfPrevPage").disabled=e<=1,document.getElementById("pdfNextPage").disabled=e>=pdfDoc.numPages,null!==pdfPageNumPending&&(renderPdfPage(pdfPageNumPending),pdfPageNumPending=null)}catch(e){pdfPageRendering=!1}}}function queueRenderPdfPage(e){pdfPageRendering?pdfPageNumPending=e:renderPdfPage(e)}function setupPdfControls(){document.getElementById("pdfPrevPage")?.addEventListener("click",(()=>{pdfPageNum<=1||(pdfPageNum--,queueRenderPdfPage(pdfPageNum))})),document.getElementById("pdfNextPage")?.addEventListener("click",(()=>{!pdfDoc||pdfPageNum>=pdfDoc.numPages||(pdfPageNum++,queueRenderPdfPage(pdfPageNum))})),document.getElementById("pdfZoomIn")?.addEventListener("click",(()=>{pdfScale>=3||(pdfScale+=.25,updateZoomLevel(),queueRenderPdfPage(pdfPageNum))})),document.getElementById("pdfZoomOut")?.addEventListener("click",(()=>{pdfScale<=.5||(pdfScale-=.25,updateZoomLevel(),queueRenderPdfPage(pdfPageNum))})),document.getElementById("pdfFitWidth")?.addEventListener("click",(async()=>{await calculateFitWidth(),queueRenderPdfPage(pdfPageNum)}))}function updateZoomLevel(){const e=document.getElementById("pdfZoomLevel");e&&(e.textContent=Math.round(100*pdfScale)+"%")}